/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWScenarioTime;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioTimeOffset;
import filenet.sim.api.VWScenarioTimeUnitType;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.IFieldCollection;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public final class VWScenarioTimeType
implements Serializable {
    private static final int MIN_TIME_TYPE = 1;
    public static final int TIME_TYPE_DATE = 1;
    public static final int TIME_TYPE_DURATION = 2;
    public static final int TIME_TYPE_OFFSET = 3;
    private static final int MAX_TIME_TYPE = 5;
    private static String[] LocalizedStrings = new String[]{new VWString("sim.api.VWScenarioTimeTypeDate", "Date").toString(), new VWString("sim.api.VWScenarioTimeTypeDuration", "Duration").toString(), new VWString("sim.api.VWScenarioTimeTypeOffset", "Offset").toString()};

    public static String getLocalizedString(int theTimeType) throws VWException {
        if (!VWScenarioTimeType.isValid(theTimeType)) {
            throw new VWException("sim.api.VWScenarioTimeTypeBadInteger", "Integer form of the time type is invalid: {0}", String.valueOf(theTimeType));
        }
        return LocalizedStrings[theTimeType - 1];
    }

    public static boolean isValid(int theTimeType) {
        return theTimeType >= 1 && theTimeType <= 5;
    }

    public static boolean isValid(Object theValue) {
        return VWScenarioTimeType.isValid(VWScenarioTimeType.getTimeType(theValue));
    }

    public static int getTimeType(Object theValue) {
        if (theValue == null) {
            return -1;
        }
        if (theValue instanceof VWScenarioTimeDuration) {
            return 2;
        }
        if (theValue instanceof VWScenarioTimeOffset) {
            return 3;
        }
        if (theValue instanceof Date) {
            return 1;
        }
        return -1;
    }

    protected static void timeValueToXML(Object timeValue, String prefix, StringBuffer buffer, String baseIndent) throws VWException {
        if (!VWScenarioTimeType.isValid(timeValue)) {
            throw new VWException("sim.api.VWScenarioTimeType.InvalidTimeValue", "The value is a {0}, which is not a supported time type.", timeValue != null ? timeValue.getClass().getName() : null);
        }
        if (prefix == null) {
            prefix = "";
        }
        buffer.append(baseIndent + "<" + prefix + "TimeExpression>\n");
        switch (VWScenarioTimeType.getTimeType(timeValue)) {
            case 1: {
                buffer.append(baseIndent + "\t" + "<" + prefix + "Calendar ");
                buffer.append("Date=\"" + VWScenarioXMLHandler.convertDateToString((Date)timeValue) + "\"/>\n");
                break;
            }
            case 3: {
                buffer.append(baseIndent + "\t");
                switch (((VWScenarioTimeOffset)timeValue).getUnits()) {
                    case 4: {
                        buffer.append("<" + prefix + "Day ");
                    }
                }
                buffer.append("Value=\"" + ((VWScenarioTimeOffset)timeValue).getOffset() + "\" ");
                buffer.append("Time=\"" + VWScenarioXMLHandler.convertTimeValue(((VWScenarioTimeOffset)timeValue).getTime()) + "\"/>\n");
                break;
            }
            case 2: {
                buffer.append(baseIndent + "\t" + "<" + prefix + "Time ");
                buffer.append("Value=\"" + ((VWScenarioTimeDuration)timeValue).getDuration() + "\" ");
                buffer.append("Units=\"" + VWScenarioTimeUnitType.typeToString(((VWScenarioTimeDuration)timeValue).getUnits()) + "\"/>\n");
            }
        }
        buffer.append(baseIndent + "</" + prefix + "TimeExpression>\n");
    }

    protected static void timeValueToXML(Object timeValue, StringBuffer buffer, String baseIndent) throws VWException {
        VWScenarioTimeType.timeValueToXML(timeValue, null, buffer, baseIndent);
    }

    protected static void validate(Object timeValue, Date absoluteBaseTime, int validationType, String objectName, IFieldCollection mainFields, IFieldCollection inheritedFields, Vector EDefVector) throws VWException {
        VWScenarioTimeType.validate(timeValue, absoluteBaseTime, validationType, objectName, null, null, null, mainFields, inheritedFields, EDefVector);
    }

    protected static void validate(Object timeValue, Date absoluteBaseTime, int validationType, String objectName, String workflowName, String mapName, Integer stepId, IFieldCollection mainFields, IFieldCollection inheritedFields, Vector EDefVector) throws VWException {
        int type = VWScenarioTimeType.getTimeType(timeValue);
        if (!VWScenarioTimeType.isValid(type)) {
            throw new VWException("sim.api.VWScenarioTimeType.InvalidTimeValue", "The value is a {0}, which is not a supported time type.", timeValue != null ? timeValue.getClass().getName() : null);
        }
        if (type != 1) {
            ((IVWScenarioTime)timeValue).validate(absoluteBaseTime, validationType, objectName, workflowName, mapName, stepId, mainFields, inheritedFields, EDefVector);
        }
    }

    protected static Date getAbsoluteTime(Object timeValue) throws VWException {
        if (timeValue == null) {
            return null;
        }
        int type = VWScenarioTimeType.getTimeType(timeValue);
        if (!VWScenarioTimeType.isValid(type)) {
            throw new VWException("sim.api.VWScenarioTimeType.InvalidTimeValue", "The value is a {0}, which is not a supported time type.", timeValue != null ? timeValue.getClass().getName() : null);
        }
        if (type == 1) {
            return (Date)timeValue;
        }
        return ((IVWScenarioTime)timeValue).getAbsoluteTime();
    }

    protected static void addUnitsToTime(Calendar time, int units, int value) {
        switch (units) {
            case 1: {
                time.add(13, value);
                break;
            }
            case 2: {
                time.add(12, value);
                break;
            }
            case 3: {
                time.add(10, value);
                break;
            }
            case 4: {
                time.add(5, value);
                break;
            }
            case 5: {
                time.add(5, value * 7);
                break;
            }
            case 6: {
                time.add(2, value);
            }
        }
    }

    protected static Object clone(Object timeValue) {
        if (timeValue == null) {
            return null;
        }
        switch (VWScenarioTimeType.getTimeType(timeValue)) {
            case 1: {
                return ((Date)timeValue).clone();
            }
            case 2: {
                return ((VWScenarioTimeDuration)timeValue).clone();
            }
            case 3: {
                return ((VWScenarioTimeOffset)timeValue).clone();
            }
        }
        return null;
    }
}

